
unit WebForm1;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls, 
  ZedGraph, System.Globalization,
  System.Data.Common;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure ZedGraphWeb1_RenderGraph(g: System.Drawing.Graphics; pane: ZedGraph.MasterPane);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    ZedGraphWeb1: ZedGraph.ZedGraphWeb;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm1.InitializeComponent;
begin
  Include(Self.ZedGraphWeb1.RenderGraph, Self.ZedGraphWeb1_RenderGraph);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // TODO: Put user code to initialize the page here
end;

procedure TWebForm1.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TWebForm1.ZedGraphWeb1_RenderGraph(g: System.Drawing.Graphics; pane: ZedGraph.MasterPane);
const
   labels: array [1..6] of string =
       ('Cinema', 'Teatro', 'Televiso', 'Leitura', 'Esportes','Internet');
   percentual_satisfacao: array [1..6] of real =
       (80, 70, 50, 90, 60, 70);
   percentual_pessoas: array [1..6] of real =
       (50, 20, 95, 40, 60, 30);

var
  Barras: array [1..2] of BarItem;
  PainelGrafico: GraphPane;
begin
  {Pega o primeiro painel do grfico. O componente ZedGraph pode
  ter vrios painis mostrando vrios grficos no mesmo objeto.}
  PainelGrafico:= Pane[0];

  //Todo o cdigo j foi explicado em outros exemplos.
  PainelGrafico.Title :=
     'Grfico de ndice de satisfao por opo de entretenimento';
  PainelGrafico.XAxis.IsTicsBetweenLabels := true;
  PainelGrafico.BarBase:= BarBase.X;

  barras[1] :=
    PainelGrafico.AddBar(
      'Satisfao', nil, percentual_satisfacao, Color.Red);
  barras[2] :=
    PainelGrafico.AddBar(
      'Pessoas que Utilizam', nil, percentual_pessoas, Color.Blue);

  PainelGrafico.YAxis.Min := 0;
  PainelGrafico.YAxis.Max := 100;
  PainelGrafico.YAxis.Step := 10;
  PainelGrafico.YAxis.Title:= 'Valores percentuais';
  PainelGrafico.XAxis.Title:= 'Opo de Entretenimento';
  PainelGrafico.XAxis.TextLabels := labels;
  PainelGrafico.XAxis.&Type := AxisType.Text;

  barras[1].Bar.Fill :=
     Fill.create(Color.Red, Color.White, Color.Red);
  barras[2].Bar.Fill :=
     Fill.create(Color.Blue, Color.White, Color.Blue);

  PainelGrafico.AxisFill :=
     Fill.Create(Color.White, Color.LightBlue, 180);
  PainelGrafico.PaneFill :=
     Fill.Create(Color.White);

  //Desenha o grfico na pgina.
  PainelGrafico.AxisChange(g);
end;

end.

